
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/clearsky.zip" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
"cs2",
"scroll",
}


local fn = function(inst)

local function sanityfn(inst)
local x,y,z = inst.Transform:GetWorldPosition()
local delta = 0
local max_rad = 10
local ents = TheSim:FindEntities(x,y,z, max_rad, nil, nil, {"USS", "bandit"})
    for k,v in pairs(ents) do 
if not (v.components.health and v.components.health:IsDead()) then
local sz = -TUNING.SANITYAURA_MED
local rad = 10
sz = sz * ( math.min(max_rad, rad) / max_rad )
local distsq = inst:GetDistanceSqToInst(v)
delta = delta + sz/math.max(1, distsq)
    end
    end
    
    return delta
end

local cs2 = Ingredient( "cs2", 1)
cs2.atlas = "images/inventoryimages/cs2.xml"
local armor_device = Recipe("cs2", { Ingredient("goldnugget", 12), cs2 }, RECIPETABS.REFINE, {REFINE=0})
armor_device.atlas = "images/inventoryimages/cs2.xml"


inst.components.builder.science_bonus = 1
--inst:AddComponent("petleash")
	inst.soundsname = "loner"
	inst:AddTag("clearsky")
	inst:AddTag("stalker")
	inst.MiniMapEntity:SetIcon( "clearsky.tex" )

inst.components.sanity.custom_rate_fn = sanityfn

	inst.components.sanity.neg_aura_mult = 0.9

	-- Stats	
	inst.components.health:SetMaxHealth(160)
	inst.components.hunger:SetMax(160)
	inst.components.sanity:SetMax(200)

end

return MakePlayerCharacter("clearsky", prefabs, assets, fn, start_inv)
